#ifndef SQUARES_H
#define SQUARES_H

#include <cstring>
#include "defs.h"

using namespace std;

const uint BRDSQ = 128;
const uint NOSQ = 121;
const uint TOTFILES = 8;
const uint TOTALRANKS = 8;

const uint RANK1 = 0;
const uint RANK2 = 1;
const uint RANK3 = 2;
const uint RANK4 = 3;
const uint RANK5 = 4;
const uint RANK6 = 5;
const uint RANK7 = 6;
const uint RANK8 = 7;

const uint FILEA = 0;
const uint FILEB = 1;
const uint FILEC = 2;
const uint FILED = 3;
const uint FILEE = 4;
const uint FILEF = 5;
const uint FILEG = 6;
const uint FILEH = 7;

const uint NOFILE = 16;
const uint NORANK = 16;

extern const uint castlebits[BRDSQ];



extern const string ranktostr;
extern const string filetostr;

extern const int rankrev[8];

const uint ranks[BRDSQ] =
{
    RANK1, RANK1, RANK1, RANK1, RANK1, RANK1, RANK1, RANK1, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK,
    RANK2, RANK2, RANK2, RANK2, RANK2, RANK2, RANK2, RANK2, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK,
    RANK3, RANK3, RANK3, RANK3, RANK3, RANK3, RANK3, RANK3, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK,
    RANK4, RANK4, RANK4, RANK4, RANK4, RANK4, RANK4, RANK4, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK,
    RANK5, RANK5, RANK5, RANK5, RANK5, RANK5, RANK5, RANK5, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK,
    RANK6, RANK6, RANK6, RANK6, RANK6, RANK6, RANK6, RANK6, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK,
    RANK7, RANK7, RANK7, RANK7, RANK7, RANK7, RANK7, RANK7, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK,
    RANK8, RANK8, RANK8, RANK8, RANK8, RANK8, RANK8, RANK8, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK, NORANK
};

const uint files[BRDSQ] =
{
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE,
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE,
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE,
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE,
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE,
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE,
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE,
    FILEA, FILEB, FILEC, FILED, FILEE, FILEF, FILEG, FILEH, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE, NOFILE
};


enum squarenames {
    A1 = 0, B1,C1,D1,E1,F1,G1,H1,
    A2 = 16, B2,C2,D2,E2,F2,G2,H2,
    A3 = 32, B3,C3,D3,E3,F3,G3,H3,
    A4 = 48, B4,C4,D4,E4,F4,G4,H4,
    A5 = 64, B5,C5,D5,E5,F5,G5,H5,
    A6 = 80, B6,C6,D6,E6,F6,G6,H6,
    A7 = 96, B7,C7,D7,E7,F7,G7,H7,
    A8 = 112, B8,C8,D8,E8,F8,G8,H8
};


enum square64names {
    sq64A1,sq64B1,sq64C1,sq64D1,sq64E1,sq64F1,sq64G1,sq64H1,
    sq64A2,sq64B2,sq64C2,sq64D2,sq64E2,sq64F2,sq64G2,sq64H2,
    sq64A3,sq64B3,sq64C3,sq64D3,sq64E3,sq64F3,sq64G3,sq64H3,
    sq64A4,sq64B4,sq64C4,sq64D4,sq64E4,sq64F4,sq64G4,sq64H4,
    sq64A5,sq64B5,sq64C5,sq64D5,sq64E5,sq64F5,sq64G5,sq64H5,
    sq64A6,sq64B6,sq64C6,sq64D6,sq64E6,sq64F6,sq64G6,sq64H6,
    sq64A7,sq64B7,sq64C7,sq64D7,sq64E7,sq64F7,sq64G7,sq64H7,
    sq64A8,sq64B8,sq64C8,sq64D8,sq64E8,sq64F8,sq64G8,sq64H8
};


const uint squarefrom64[64] = {
    A1, B1,C1,D1,E1,F1,G1,H1,
    A2, B2,C2,D2,E2,F2,G2,H2,
    A3, B3,C3,D3,E3,F3,G3,H3,
    A4, B4,C4,D4,E4,F4,G4,H4,
    A5, B5,C5,D5,E5,F5,G5,H5,
    A6, B6,C6,D6,E6,F6,G6,H6,
    A7, B7,C7,D7,E7,F7,G7,H7,
    A8, B8,C8,D8,E8,F8,G8,H8
};

const uint squareto64[128] = {
sq64A1,sq64B1,sq64C1,sq64D1,sq64E1,sq64F1,sq64G1,sq64H1,0,0,0,0,0,0,0,0,
sq64A2,sq64B2,sq64C2,sq64D2,sq64E2,sq64F2,sq64G2,sq64H2,0,0,0,0,0,0,0,0,
sq64A3,sq64B3,sq64C3,sq64D3,sq64E3,sq64F3,sq64G3,sq64H3,0,0,0,0,0,0,0,0,
sq64A4,sq64B4,sq64C4,sq64D4,sq64E4,sq64F4,sq64G4,sq64H4,0,0,0,0,0,0,0,0,
sq64A5,sq64B5,sq64C5,sq64D5,sq64E5,sq64F5,sq64G5,sq64H5,0,0,0,0,0,0,0,0,
sq64A6,sq64B6,sq64C6,sq64D6,sq64E6,sq64F6,sq64G6,sq64H6,0,0,0,0,0,0,0,0,
sq64A7,sq64B7,sq64C7,sq64D7,sq64E7,sq64F7,sq64G7,sq64H7,0,0,0,0,0,0,0,0,
sq64A8,sq64B8,sq64C8,sq64D8,sq64E8,sq64F8,sq64G8,sq64H8,0,0,0,0,0,0,0,0
};

const uint sqrev[128] = {
    A8,B8,C8,D8,E8,F8,G8,H8,0,0,0,0,0,0,0,0,
    A7,B7,C7,D7,E7,F7,G7,H7,0,0,0,0,0,0,0,0,
    A6,B6,C6,D6,E6,F6,G6,H6,0,0,0,0,0,0,0,0,
    A5,B5,C5,D5,E5,F5,G5,H5,0,0,0,0,0,0,0,0,
    A4,B4,C4,D4,E4,F4,G4,H4,0,0,0,0,0,0,0,0,
    A3,B3,C3,D3,E3,F3,G3,H3,0,0,0,0,0,0,0,0,
    A2,B2,C2,D2,E2,F2,G2,H2,0,0,0,0,0,0,0,0,
    A1,B1,C1,D1,E1,F1,G1,H1,0,0,0,0,0,0,0,0
};



inline bool onbrd(const uint &sq) { return ( (sq & 0x88)==0); }
inline uint sqfrom64(const uint &sq) { return squarefrom64[sq]; }
inline uint sqto64(const uint &sq) { return squareto64[sq]; }
extern string printsquare(uint sq);
extern uint fr2sq(uint f, uint r);
extern uint str2sq(string sq);
extern uint chartorank(const char rank);
extern uint chartofile(const char file);


#endif
